/************************************************************/
/* PROJECT NAME: VICnonvector                               */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example configuration of VIC for nonvectored interrupt   */
/*															*/
/* Demonstrates serving the external interrupt as a non		*/ 
/* vectored interrupt										*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <LPC21xx.H>
void NonVectoredIRQ (void)__irq;
unsigned update = 0;

int main (void)
{

IODIR1			= 0x00FF0000;						//Set the LED pins as outputs
IOCLR1			= 0x00FF0000;						//Clear the LED pins

PINSEL0 		= ;									//Enable the EXTINT0 interrupt

VICDefVectAddr 	= ;									//pass the address of the IRQ into the VIC slot

VICIntEnable	= ;									//Enable EXTINT0 in the VIC

while(1)
{
;													//Idle loop
}

}

void NonVectoredIRQ (void)	 __irq
{
if(VICIRQStatus&)									//Test for the interrupt source
{
	IOSET1 		= 0x00FF0000;						//Set the LED pins
	EXTINT  	= ;									//Clear the peripheral interrupt flag
}
VICVectAddr 	= ;									//Dummy write to signal end of interrupt
}
